/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.render;

import com.Da_Technomancer.essentials.render.RenderUtil;
import com.Da_Technomancer.essentials.tileentities.ILinkTE;
import com.Da_Technomancer.essentials.tileentities.LinkHelper;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class LinkLineRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("essentials", "textures/model/link_line.png");
    protected static RenderType LINK_TYPE = DummyRenderType.initType();

    public LinkLineRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void m_6922_(T te, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (!LinkHelper.isLinkTool(Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND)) && !LinkHelper.isLinkTool(Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.OFF_HAND))) {
            return;
        }
        Vec3 tePos = new Vec3((double)te.m_58899_().m_123341_() + 0.5, (double)te.m_58899_().m_123342_() + 0.5, (double)te.m_58899_().m_123343_() + 0.5);
        matrix.m_85836_();
        matrix.m_85837_(0.5, 0.5, 0.5);
        VertexConsumer builder = buffer.m_6299_(LINK_TYPE);
        Color linkCol = ((ILinkTE)te).getColor();
        float alpha = 0.7f;
        int[] col = new int[]{linkCol.getRed(), linkCol.getGreen(), linkCol.getBlue(), (int)(alpha * 255.0f)};
        float uWidth = 0.33333334f;
        for (BlockPos link : ((ILinkTE)te).getLinks()) {
            Vec3 line = Vec3.m_82528_((Vec3i)link);
            Vec3 widthVec = RenderUtil.findRayWidth(tePos, line, 0.3f);
            Vec3 normal = line.m_82537_(widthVec);
            float length = (float)line.m_82553_();
            RenderUtil.addVertexBlock(builder, matrix, (Position)widthVec.m_82490_(-1.0), 0.0f, 0.0f, (Position)normal, alpha, 0xF000F0);
            RenderUtil.addVertexBlock(builder, matrix, (Position)widthVec, uWidth, 0.0f, (Position)normal, alpha, 0xF000F0);
            RenderUtil.addVertexBlock(builder, matrix, (Position)line.m_82549_(widthVec), uWidth, length / 3.0f, (Position)normal, alpha, 0xF000F0);
            RenderUtil.addVertexBlock(builder, matrix, (Position)line.m_82546_(widthVec), 0.0f, length / 3.0f, (Position)normal, alpha, 0xF000F0);
            RenderUtil.addVertexBlock(builder, matrix, (Position)widthVec.m_82490_(-1.0), uWidth, 0.0f, (Position)normal, 0xF000F0, col);
            RenderUtil.addVertexBlock(builder, matrix, (Position)widthVec, uWidth * 2.0f, 0.0f, (Position)normal, 0xF000F0, col);
            RenderUtil.addVertexBlock(builder, matrix, (Position)line.m_82549_(widthVec), uWidth * 2.0f, length / 3.0f, (Position)normal, 0xF000F0, col);
            RenderUtil.addVertexBlock(builder, matrix, (Position)line.m_82546_(widthVec), uWidth, length / 3.0f, (Position)normal, 0xF000F0, col);
        }
        matrix.m_85849_();
    }

    public boolean m_5932_(T te) {
        return true;
    }

    private static class DummyRenderType
    extends RenderType {
        private DummyRenderType(String p_i225992_1_, VertexFormat p_i225992_2_, VertexFormat.Mode p_i225992_3_, int p_i225992_4_, boolean p_i225992_5_, boolean p_i225992_6_, Runnable p_i225992_7_, Runnable p_i225992_8_) {
            super(p_i225992_1_, p_i225992_2_, p_i225992_3_, p_i225992_4_, p_i225992_5_, p_i225992_6_, p_i225992_7_, p_i225992_8_);
        }

        private static RenderType initType() {
            return RenderType.m_173215_((String)"link_line", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173097_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TEXTURE, false, false)).m_110685_(RenderStateShard.f_110139_).m_110691_(false));
        }
    }
}

